-- 9_Drag and Drop

local Button = class()

function setup()
    -- prepare any object with x,y,w,h fields, here a button
    button1 = Button("drag me", WIDTH/3*2+100,HEIGHT/3,50, color(0, 255, 0, 255) , "1")
    button2 = Button("drag me", WIDTH/3*2+100,HEIGHT/3*2,50, color(0, 200, 0, 255) , "2")
    button3 = Button("drag me,\ndrop on me", WIDTH/3,HEIGHT/2,150, color(255, 190, 0, 255))
    button3.on_Drop = function(self,obj)
        local x,y
        if obj.id == "1" then x = self.x - self.w + obj.w +10 end
        if obj.id == "2" then x = self.x + self.w - obj.w -10 end
        local y = self.y - self.h + obj.h +10
        tween(0.5, obj, {x=x,y=y}, tween.easing.bounceOut)
    end
    -- ############### and add events to sensors  #################
    button1.sensor:onDrag( function(event) button1:on_Drag(event.touch) end )
    button2.sensor:onDrag( function(event) button2:on_Drag(event.touch) end )
    button3.sensor:onDrag( function(event) button3:on_Drag(event.touch) end )
    -- droppabled and drop-in objects should listen to onDrop, ...
    button1.sensor:onDrop( function(event) end )    -- even if the callback does nothing
    button2.sensor:onDrop( function(event) end )
    button3.sensor:onDrop( function(event) button3:on_Drop(event.object) end)
    -- ############### #################  #################
end
function touched(t)
    -- ######### add this in your touched function #########
    -- make sure your calls are in the good order
    if button1:touched(t) then return true end
    if button2:touched(t) then return true end
    if button3:touched(t) then return true end
    if intercepted then return true end
end
function draw()
    noStroke()
    background(178, 178, 178, 255)     
    button3:draw()
    button2:draw()
    button1:draw()
end

function Button:init(txt,x,y,r,color,id)
    self.x = x
    self.y = y
    self.w = r
    self.h = r
    self.txt = txt
    self.color = color
    self.id = id
    self.sensor = Sensor{ parent=self, xywhMode=RADIUS }
end
function Button:on_Drag( t )
    self.x = self.x + t.deltaX
    self.y = self.y + t.deltaY
end
function Button:touched(t)
    return self.sensor:touched(t)
end
function Button:draw()
    noStroke()
    fill(self.color) -- button color
    rectMode(RADIUS)
    rect(self.x,self.y,self.w,self.h)
    fill(57, 57, 57, 255)         -- set color for text
    fontSize(20)            -- set font size
    textAlign(CENTER)
    textWrapWidth(self.w*1.8)
    text(self.txt,self.x,self.y)       -- draw text on screen)      
end


